@extends('layouts.guest')

@section('title', 'Create an Account')

@section('styles')
@parent

@endsection

@section('content')
<section class="y auth">
        <div class="container">
            <div class="pb-3 row justify-content-center">

                <div class="col-12 col-md-6 col-lg-6 col-sm-10 col-xl-6">
                    <div class="text-center">
                        <a href="/"><img src="{{ asset('storage/app/public/'.$settings->logo)}}" alt="" class="mb-3 img-fluid auth__logo"></a>
                    </div>
                    
                    
                            @if(Session::has('status'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                {{ Session::get('status') }}
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            @endif
                        
                    
                    <div class="bg-white shadow card login-page roundedd border-1 ">
                        <div class="card-body">
                            <h4 class="text-center card-title">Create an Account</h4>
                            <form method="POST" action="{{ route('register') }}"  class="mt-4 login-form">
                                 @csrf
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>UserName <span class="text-danger">*</span></label>
                                            <div class="position-relative">
                                                <i data-feather="user" class="fea icon-sm icons"></i>
                                                <input type="text" id="input1" class="pl-5 form-control"  name="username" id="input1" placeholder="Enter Unique Username" required>
                                                
                                                @if ($errors->has('username'))
                                                <small class="text-danger">{{ $errors->first('username') }}</small>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <!--end col-->
                                    
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>FullName <span class="text-danger">*</span></label>
                                            <div class="position-relative">
                                                <i data-feather="user-check" class="fea icon-sm icons"></i>
                                                <input type="text" class="pl-5 form-control"  name="name" value="{{ old('name') }}" id="f_name" placeholder="Enter FullName" required>
                                                
                                                @if ($errors->has('name'))
                                                <small class="text-danger">{{ $errors->first('name') }}</small>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <!--end col-->
                                    
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>Your Email <span class="text-danger">*</span></label>
                                            <div class="position-relative">
                                                <i data-feather="mail" class="fea icon-sm icons"></i>
                                                <input type="email" class="pl-5 form-control" name ="email" value="{{ old('email') }}" id="email" placeholder="name@example.com" required>
                                                @if ($errors->has('email'))
                                                <small class="text-danger">{{ $errors->first('email') }}</small>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <!--end col-->

                                    
                                    
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>Phone Number <span class="text-danger">*</span></label>
                                            <div class="position-relative">
                                                <i data-feather="phone" class="fea icon-sm icons"></i>
                                                <input type="phone" class="pl-5 form-control" name="phone" value="{{ old('phone') }}" id="phone" placeholder="Enter Phone number" required>
                                                @if ($errors->has('phone'))
                                                <small class="text-danger">{{ $errors->first('phone') }}</small>
                                                @endif
                                                
                                            </div>
                                        </div>
                                    </div>
                                    <!--end col-->
                                    
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>Password <span class="text-danger">*</span></label>
                                            <div class="position-relative">
                                                <i data-feather="key" class="fea icon-sm icons"></i>
                                                <input type="password" class="pl-5 form-control" name="password" id="password" placeholder="Enter Password" required>
                                                @if ($errors->has('password'))
                                                <small class="text-danger">{{ $errors->first('password') }}</small>
                                                @endif
                                                
                                            </div>
                                        </div>
                                    </div>
                                    <!--end col-->
                                    
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>Confirm Password <span class="text-danger">*</span></label>
                                            <div class="position-relative">
                                                <i data-feather="key" class="fea icon-sm icons"></i>
                                                <input type="password" class="pl-5 form-control" name="password_confirmation" value="{{ old('password_confirmation') }}" id="confirm-password" placeholder="Confirm Password" required>
                                                @if ($errors->has('password'))
                                                <small class="text-danger">{{ $errors->first('password') }}</small>
                                                @endif
                                                
                                            </div>
                                        </div>
                                    </div>
                                    <!--end col-->
                                    
                                    <div class="col-md-12">
                                        <div class="form-group ">
                                            <label>Country <span class="text-danger">*</span></label>
                                            <div class="position-relative">
                                                <i data-feather="map-pin" class="fea icon-sm icons"></i>
                                                <select class="pl-5 d-block w-100 px-2 py-3 border border-light rounded-right" name="country" id="country" required>
                                                    <option selected disabled>Choose Country</option>
                                                        @include('auth.countries')
                                                </select>
                                            </div>
                                            @if ($errors->has('country'))
                                            <small class="text-danger">{{ $errors->first('country') }}</small>
                                            @endif
                                        </div>
                                    </div>
                                    
                                    @if(Session::has('ref_by'))
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>Referral ID <span class="text-danger">*</span></label>
                                            <div class="position-relative">
                                                <i data-feather="user" class="fea icon-sm icons"></i>
                                                <input type="text" class="pl-5 form-control"  value="{{session('ref_by')}}" name="ref_by" placeholder="optional referral id" readonly>
                                            </div>
                                        </div>
                                    </div>
                                    @else
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>Referral ID</label>
                                            <div class="position-relative">
                                                <i data-feather="user" class="fea icon-sm icons"></i>
                                                <input type="text" class="pl-5 form-control"  name="ref_by" placeholder="optional referral id">
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                                    
                                    @if($settings->captcha == "true")
                                    <div class="col-lg-12">
                                        <div class="form-group  {{ $errors->has('g-recaptcha-response') ? ' has-error' : '' }}">
                                            <label>Captcha<span class="text-danger">*</span></label>
                                            <div class="position-relative">
                                                {!! NoCaptcha::display() !!}
                                                @if ($errors->has('g-recaptcha-response'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('g-recaptcha-response') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                                    @if($terms->useterms =='yes')
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input" id="customCheck1" required>
                                                    <label class="custom-control-label" for="customCheck1">I Accept the <a
                                                            href="{{route('privacy')}}" class="text-primary">Terms And Privacy Policy</a></label>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                    
                                    <!--end col-->

                                    <div class="mb-0 col-lg-12">
                                        <button class="btn btn-primary btn-block pad" type="submit">Register</button>
                                    </div>
                                    <!--end col-->

                                    <div class="mt-4 text-center col-lg-12">
                                        @if($settings->enable_social_login == "yes")
                                        <h6>Or Login With</h6>
                                        <div class="row">
                                            <!--end col-->
                                            <div class="mt-3 col-12">
                                                <a href="{{route('social.redirect', ['social' => 'google'])}}" class="btn btn-block btn-light"><i
                                                        class="mdi mdi-google text-danger"></i> Google</a>
                                            </div>
                                            <!--end col-->
                                        </div>
                                        @endif
                                    </div>
                                    <!--end col-->
                                    <!--end col-->

                                    <div class="text-center col-12">
                                        <p class="mt-3 mb-0"><small class="mr-2 text-dark">Already have an account
                                                </small> <a href="{{ route('login') }}"
                                                class="text-dark font-weight-bold">Login</a></p>
                                    </div>
                                    <!--end col-->
                                    
                                    <div class="text-center col-12">
                                        <p class="mt-4 mb-0"><small class="mr-2 text-dark">&copy; Copyright  {{date('Y')}} &nbsp; {{$settings->site_name}} &nbsp; All Rights Reserved.</small>
                                        </p>
                                    </div>
                                </div>
                                <!--end row-->
                            </form>
                        </div>
                    </div>
                    <!---->
                </div>
                <!--end col-->
            </div>
            <!--end row-->
        </div>
        <!--end container-->
    </section>
    <!--end section-->

<!-- GetButton.io widget -->
<script async src='https://d2mpatx37cqexb.cloudfront.net/delightchat-whatsapp-widget/embeds/embed.min.js'></script>
        <script>
          var wa_btnSetting = {"btnColor":"#16BE45","ctaText":"WhatsApp ","cornerRadius":40,"marginBottom":"30","marginLeft":20,"marginRight":20,"btnPosition":"left","whatsAppNumber":"94773148044","welcomeMessage":"Hello","zIndex":999999,"btnColorScheme":"light"};
          window.onload = () => {
            _waEmbed(wa_btnSetting);
          };
        </script>
      

<script src="//code.jivosite.com/widget/uUip2UwhIC" async></script>


<style>
.mgm {
    border-radius: 7px;
    position: fixed;
    z-index: 90;
    bottom: 180px;
    right: 20px;
    background: #fff;
    border:1px solid #fff;
    padding: 5px 22px;
    box-shadow: 0px 5px 13px 0px rgba(0, 0, 0, .3);
}

.mgm a {
    font-weight: 500;
    display: block;
    color: #330000;
}

.mgm a,
.mgm a:active {
    transition: all .5s ease;
    color: #8696a9;
}
</style>
<div class="mgm" style="display: none;">
<div class="txt" style="color:#6e00f7;"></div>
</div>

<script data-cfasync="false" src="#"></script>
<script type="text/javascript">
    var listCountries = ['USA', 'Portugal', 'Germany', 'France', 'Italy', 'Namibia', 'Australia', 'South Africa', 'Canada', 'Argentina', 'Saudi Arabia', 'Mexico', 'Portugal', 'Brazil', 'Venezuela', 'Isreal', 'Sweden', 'USA', 'Colombia', 'Italy', 'Canada', 'United Kingdom', 'USA', 'Greece', 'Cuba', 'Germany', 'Portugal', 'Austria', 'Mexico', 'Panama', 'South Africa', 'USA', 'Netherlands', 'Switzerland', 'Belgium', 'Israel', 'Cyprus'];
    var listPlans = ['$51,000', '$14,500', '$40,000', '$1,000', '$10,000', '$50,000', '$52,300', '$9,700', '$10,000', '$4,500', '$9,500', '$34,000', '$42,000', '$4,600', '$3,700', '$27,500','$58,623','$31,600'];
    var transarray = ['just <b>invested</b>', 'has <b>withdrawn</b>', 'is <b>trading with</b>'];
    interval = Math.floor(Math.random() * (40000 - 8000 + 1) + 8000);
    var run = setInterval(request, interval);

    function request() {
        clearInterval(run);
        interval = Math.floor(Math.random() * (40000 - 8000 + 1) + 8000);
        var country = listCountries[Math.floor(Math.random() * listCountries.length)];
        var transtype = transarray[Math.floor(Math.random() * transarray.length)];
        var plan = listPlans[Math.floor(Math.random() * listPlans.length)];
        var msg = 'Someone from <b>' + country + '</b> ' + transtype + ' <a href="javascript:void(0);" onclick="javascript:void(0);">' + plan + '</a>';
        $(".mgm .txt").html(msg);
        $(".mgm").stop(true).fadeIn(300);
        window.setTimeout(function() {
            $(".mgm").stop(true).fadeOut(300);
        }, 6000);
        run = setInterval(request, interval);
    }
</script>
 
 <script>
        $(document).keydown(function(event){
          if(event.keyCode == 123){
            return false;
          }else if(event.ctrlKey && event.shiftKey && event.keyCode == 73){
            return false;
          }
        })
        document.addEventListener('contextmenu',event => event.preventDefault())
</script>

@endsection

@section('scripts')
@parent
<script>
    $('#input1').on('keypress', function(e) {
        return e.which !== 32;
    });
</script>
@endsection